<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

$today = date("Y-m-d");
$time = date("H:i:s");

if (!isset($_SESSION['is_logged_in'])) {
    echo "Session expired. Please log in again.";
    exit;
}

$login_name = $_SESSION["LOGIN_NAME"];
$login_pass = $_SESSION["EMPLOYEE_PASSWORD"];

// Authenticate user
$querylogin = "SELECT * FROM mst_users WHERE user_name = ? AND password = ?";
$stmt = $conn->prepare($querylogin);
$stmt->bind_param("ss", $login_name, $login_pass);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    echo "Invalid user session.";
    exit;
}

$entry_by  = $user['user_id'];

// Inputs from form
$order_id = intval($_POST['order_id'] ?? 0);
$jcno = $_POST['jcno'] ?? '';
$current_step = intval($_POST['step'] ?? 0);
$confirmed_ids = $_POST['confirm'] ?? [];

if (empty($order_id) || empty($jcno)) {
    echo "Missing order or JCNO.";
    exit;
}

// Step 1: Update selected order_details rows
if (!empty($confirmed_ids)) {
    $placeholders = implode(',', array_fill(0, count($confirmed_ids), '?'));
    $types = str_repeat('i', count($confirmed_ids));

    $update_sql = "UPDATE order_details SET confirm_date = ?, confirm_status = 'YES' WHERE id IN ($placeholders)";
    $stmt = $conn->prepare($update_sql);
    $params = array_merge([$today], $confirmed_ids);
    $stmt->bind_param("s$types", ...$params);
    $stmt->execute();
    $stmt->close();
}

// Step 2: Check if ALL order_details rows are confirmed
$check_sql = "SELECT COUNT(*) AS pending FROM order_details WHERE order_id = ? AND (confirm_status IS NULL OR confirm_status != 'YES')";
$stmt = $conn->prepare($check_sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$check_result = $stmt->get_result();
$pending_row = $check_result->fetch_assoc();
$pending_count = $pending_row['pending'] ?? 0;
$stmt->close();

// Step 3: If no pending rows, move Job_order_Status forward
if ($pending_count == 0) {
    // Log current stage
    $stage_sql = "SELECT stage FROM Stage_master WHERE step = ?";
    $stage_stmt = $conn->prepare($stage_sql);
    $stage_stmt->bind_param("i", $current_step);
    $stage_stmt->execute();
    $stage_result = $stage_stmt->get_result();
    $stage_row = $stage_result->fetch_assoc();
    $current_stage = $stage_row['stage'] ?? 'Unknown';
    $stage_stmt->close();

    // Insert into history
    $entry_date = date('Y-m-d');
    $entry_time = date('H:i:s');
    $status = $current_stage;

    $history_stmt = $conn->prepare("INSERT INTO job_order_history (jcno, stage, step, entry_by, entry_date, entry_time, status) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $history_stmt->bind_param("ssissss", $jcno, $current_stage, $current_step, $entry_by, $entry_date, $entry_time, $status);
    $history_stmt->execute();
    $history_stmt->close();

    // Move to next step
    $new_step = $current_step + 1;

    $stage_stmt = $conn->prepare("SELECT stage FROM Stage_master WHERE step = ?");
	$stage_stmt->bind_param("i", $new_step);
	$stage_stmt->execute();
	$stage_result = $stage_stmt->get_result();
	$stage_row = $stage_result->fetch_assoc();
	$new_stage = $stage_row['stage']; // Fallback to avoid null
	$stage_stmt->close();
	
	// Use the same $new_stage for both `status` and `stage`
	$update_stmt = $conn->prepare("UPDATE Job_order_Status SET status = ?, step = ?, stage = ?, confirm_date = ? WHERE jcno = ?");
	$update_stmt->bind_param("sisss", $new_stage, $new_step, $new_stage, $today, $jcno);

	$update_stmt->execute();
	$update_stmt->close();
	
	echo "Saved successfully. Status moved to next step.";
	} else {
		echo "Saved, but awaiting all validations to proceed.";
	}

$conn->close();
?>
