<?php
include "connection.php"; // your DB connection

$ids = $_POST['ids'] ?? '';
if (!$ids) {
    die("No items selected.");
}

$idArray = explode(",", $ids);

// Escape values safely for SQL
$idArray = array_map('intval', $idArray);
$idList = implode(",", $idArray);

// Fetch selected rows
$sql = "SELECT product, colour, width, height, sqft, qty, depth, thickness, material, finish, back_colour, grain_direction 
        FROM order_details WHERE id IN ($idList)";
$result = $conn->query($sql);

// Send headers for CSV download
$filename = "selected_items_" . date("Ymd_His") . ".csv";
header("Content-Type: text/csv");
header("Content-Disposition: attachment; filename=\"$filename\"");

// Open output stream
$output = fopen("php://output", "w");

// Write header row
fputcsv($output, ["Product", "Colour", "Width", "Height", "Sq Ft", "Qty", "Depth", "Thickness", "Material", "Finish", "Back Colour", "Grain Direction"]);

// Write data rows
while ($row = $result->fetch_assoc()) {
    fputcsv($output, $row);
}

fclose($output);
exit;
?>
