<?php

include 'connection.php';



header('Content-Type: text/csv; charset=utf-8');

header('Content-Disposition: attachment; filename=lead_tracker_report.csv');



$output = fopen('php://output', 'w');



// Column headers

fputcsv($output, [

    'Stage',

    'Customer Name',

    'Address',

    'Requirements',

    'Lead Owner',

    'Date',

    'Month',

    'Status',

    'Lead Temp',

    'Product',

    'Enquiry Status',

    'Architect Name',

    'Quotation Amount',

    'Quote Date',

    'Payment Date',

    'Last Remark'

]);



// Build filters

$filters = [];



if (!empty($_GET['customer_name'])) {

    $customer_name = mysqli_real_escape_string($conn, $_GET['customer_name']);

    $filters[] = "customer_name LIKE '%$customer_name%'";

}

if (!empty($_GET['lead_owner'])) {

    $lead_owner = mysqli_real_escape_string($conn, $_GET['lead_owner']);

    $userResult = mysqli_query($conn, "SELECT user_id FROM mst_users WHERE name LIKE '%$lead_owner%'");

    $userIds = [];

    while ($u = mysqli_fetch_assoc($userResult)) {

        $userIds[] = "'" . $u['user_id'] . "'";

    }

    if (!empty($userIds)) {

        $filters[] = "assign_to IN (" . implode(",", $userIds) . ")";

    }

}

if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {

    $from = mysqli_real_escape_string($conn, $_GET['from_date']);

    $to = mysqli_real_escape_string($conn, $_GET['to_date']);

    $filters[] = "date BETWEEN '$from' AND '$to'";

}

if (!empty($_GET['enquiry_priority'])) {

    $priority = mysqli_real_escape_string($conn, $_GET['enquiry_priority']);

    $filters[] = "LOWER(enquiry_priority) = LOWER('$priority')";

}

if (!empty($_GET['status'])) {

    $status = mysqli_real_escape_string($conn, $_GET['status']);

    $filters[] = "LOWER(status) LIKE LOWER('%$status%')";

}

if (!empty($_GET['enquiry_status']) && is_array($_GET['enquiry_status'])) {
    $statuses = array_map(function($status) use ($conn) {
        return "'" . mysqli_real_escape_string($conn, $status) . "'";
    }, $_GET['enquiry_status']);

    $status_list = implode(",", $statuses);

    $filters[] = "enquiry_status IN ($status_list)";
}


if (!empty($_GET['branch'])) {

    $branch = mysqli_real_escape_string($conn, $_GET['branch']);

    $filters[] = "Branch = '$branch'";

}

if (!empty($_GET['architech_name'])) {

    $architech_name = mysqli_real_escape_string($conn, $_GET['architech_name']);

    $filters[] = "architech_name LIKE '%$architech_name%'";

}



$whereClause = !empty($filters) ? "WHERE " . implode(" AND ", $filters) : "";

$query = "SELECT * FROM customer_leads $whereClause ORDER BY lead_id DESC";

$result = mysqli_query($conn, $query);



while ($row = mysqli_fetch_assoc($result)) {

    $requirements = implode(", ", array_map('trim', explode(",", $row['requirement'] ?? '')));

    $leadTemp = ucfirst(strtolower($row['enquiry_priority'] ?? ''));

    //$status = ucwords(str_replace('_', ' ', $row['enquiry_status'] ?? ''));

	$step = $row['step'] ?? '';

$received_amt = $row['received_amt'] ?? '';

$order_no = $row['order_no'] ?? '';

$lead_id = $row['lead_id'] ?? '';

$original_status = $row['enquiry_status'] ?? '';



$enquiry_status = ucwords(str_replace('_', ' ', $original_status)); // Default value

if($enquiry_status=='Order Closed') {

        $enquiry_status = 'Signoffdone';



}
if($enquiry_status=='Quote Submitted') {
$enquiry_status='Quote Ready';
}
if($enquiry_status=='Quote Send Client') {
$enquiry_status='Quote Submitted';
}
if ($step === '4') {

    if ($received_amt === '') {

        $enquiry_status = 'Quote Approve waiting for Token';

    } elseif ($received_amt !== '' && $order_no === '') {

        $enquiry_status = 'Token Amount Recived';

    } elseif ($received_amt !== '' && $order_no !== '') {

        $enquiry_status = '50% Received';

    }

}



    $stage = ucwords(str_replace('_', ' ', $row['lead_status'] ?? ''));

    $formattedDate = !empty($row['date']) ? date('d/m/Y', strtotime($row['date'])) : '';

    $monthName = !empty($row['date']) ? date('M', strtotime($row['date'])) : '';



    $assign_to = $row['assign_to'] ?? '';

    $segment_code = $row['segments'] ?? '';

    $quotation_amt = $row['quotation_amt'] ?? '';

    $qtn_date = !empty($row['qtn_date']) ? date('d/m/Y', strtotime($row['qtn_date'])) : '';

    $payment_date = !empty($row['payment_date']) ? date('d/m/Y', strtotime($row['payment_date'])) : '';

    $last_remark = $row['last_conversation_details'] ?? '';

$parts = [];



if (!empty($row['architech_name'])) {

    $parts[] = $row['architech_name'];

}

if (!empty($row['exhibition_name'])) {

    $parts[] = $row['exhibition_name'];

}

if (!empty($row['ref_name'])) {

    $parts[] = $row['ref_name'];

}

if (!empty($row['social_media_platform'])) {

    $parts[] = $row['social_media_platform'];

}

if (!empty($row['builder_name'])) {

    $parts[] = $row['builder_name'];

}

if (!empty($row['builder_contact_person'])) {

    $parts[] = $row['builder_contact_person'];

}



$combined_info = implode(' / ', $parts); // Join with /



    // Get lead owner name

    $lead_owner_name = '';

    $userRes = mysqli_query($conn, "SELECT name FROM mst_users WHERE user_id = '$assign_to'");

    if ($u = mysqli_fetch_assoc($userRes)) {

        $lead_owner_name = $u['name'];

    }



    // Get product/segment name

    $segment_name = '';

    $segRes = mysqli_query($conn, "SELECT * FROM segment WHERE sid = '$segment_code'");

    if ($s = mysqli_fetch_assoc($segRes)) {

        $segment_name = $s['segment'];

    }



    // Export row

    fputcsv($output, [

        $stage,

        $row['customer_name'],

        $row['address'],

        $requirements,

        $lead_owner_name,

        $formattedDate,

        $monthName,

        $row['status'],

        $leadTemp,

        $segment_name,

        $enquiry_status,

        $combined_info,

        $quotation_amt,

        $qtn_date,

        $payment_date,

        $last_remark

    ]);

}



fclose($output);

exit;

?>

