<?php 
session_start();
include 'connection.php';

header('Content-Type: application/json');

if (!isset($_SESSION['is_logged_in'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $brand_name = trim($_POST['brand_name'] ?? '');

    if (empty($brand_name)) {
        echo json_encode(['status' => 'error', 'message' => 'Brand name is required.']);
        exit();
    }

    $brand_name = mysqli_real_escape_string($conn, $brand_name);

    // Check for duplicate brand
    $checkQuery = "SELECT COUNT(*) AS count FROM Abrand_master WHERE LOWER(brand_name) = LOWER(?)";
    $stmt = mysqli_prepare($conn, $checkQuery);
    mysqli_stmt_bind_param($stmt, "s", $brand_name);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $count);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);

    if ($count > 0) {
        echo json_encode(['status' => 'error', 'message' => 'Duplicate: Brand already exists.']);
        exit();
    }

    // Insert new brand
    $insertQuery = "INSERT INTO Abrand_master (brand_name) VALUES (?)";
    $stmt = mysqli_prepare($conn, $insertQuery);
    mysqli_stmt_bind_param($stmt, "s", $brand_name);

    if (mysqli_stmt_execute($stmt)) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Brand inserted successfully.',
            'brand' => ['brand_name' => htmlspecialchars($brand_name)]
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Insert failed: ' . mysqli_stmt_error($stmt)]);
    }

    mysqli_stmt_close($stmt); // Clean up
}
?>
