<?php ob_clean();
session_start();
header('Content-Type: application/json');
include 'connection.php';
if (!isset($_SESSION['is_logged_in'])) {
    header("Location: login.php");
    exit();
}

if (!isset($_SESSION["LOGIN_NAME"])) {
    echo json_encode(['status' => 'error', 'message' => 'LOGIN_NAME missing']);
    exit;
}
if (!isset($_SESSION["EMPLOYEE_PASSWORD"])) {
    echo json_encode(['status' => 'error', 'message' => 'EMPLOYEE_PASSWORD missing']);
    exit;
}
// Check session login
$querylogin = "SELECT * FROM mst_users WHERE user_name = ? AND password = ?";
$stmtLogin = $conn->prepare($querylogin);
$stmtLogin->bind_param("ss", $_SESSION["LOGIN_NAME"], $_SESSION["EMPLOYEE_PASSWORD"]);
$stmtLogin->execute();
$resultlogin = $stmtLogin->get_result();
$branch = '';
$user_id = '';

if ($row = $resultlogin->fetch_assoc()) {
    $branch = $row['branch'];
    $user_id = $row['user_id'];
}
$stmtLogin->close();


$login_id = $_SESSION['user_id'] ?? $user_id;
$LOGIN_NAME = $_SESSION['username'] ?? $_SESSION['LOGIN_NAME'];
$today = date('Y-m-d');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Correct input assignments
    $firm_id = $_REQUEST['firm_id'] ?? '';
    $architect_id = $_REQUEST['architect_id'] ?? '';
    $followup_details = $_POST['followup_details'] ?? '';
    $next_reminder_date = $_POST['next_reminder_date'] ?? null;
    $next_reminder_time = $_POST['next_reminder_time'] ?? null;
    $followup_type = $_POST['followup_type'] ?? '';
    $call_followup_id = isset($_REQUEST['call_followup_id']) ? (int)$_REQUEST['call_followup_id'] : 0;
    $architect_name = $_POST['architect_name'] ?? '';

    // Basic validations
    if (empty($followup_type) || empty($call_followup_id)) {
        echo json_encode(['status' => 'error', 'message' => 'Required fields are missing.']);
        exit;
    }

    //  Update step name in call_followup
    $qrycall = "UPDATE call_followup SET step_name = ? WHERE call_followup_id = ?";
    $stmtCall = $conn->prepare($qrycall);
    $stmtCall->bind_param("si", $followup_type, $call_followup_id);
    $stmtCall->execute();
    $stmtCall->close();

    //  Insert into architect_followup
    $insertFollowup = "INSERT INTO architect_followup (
        call_followup_id, firm_id, architect_id, new_architect_name, architect_mobile_no,
        followup_details, next_reminder_date, next_reminder_time, followup_type, architect_name
    ) VALUES (?, ?, ?, '', '', ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($insertFollowup);
    if (!$stmt) {
        echo json_encode(['status' => 'error', 'message' => 'Prepare failed: ' . $conn->error]);
        exit;
    }

    // Correct types: i = int, s = string
    $stmt->bind_param(
        "isssssss",
        $call_followup_id,
        $firm_id,
        $architect_id,
        $followup_details,
        $next_reminder_date,
        $next_reminder_time,
        $followup_type,
        $architect_name
    );

    if ($stmt->execute()) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Follow-up saved successfully.',
            'call_followup_id' => $call_followup_id
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Execution failed: ' . $stmt->error]);
    }

    $stmt->close();
    $conn->close();

} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>
