<?php
session_start();
include 'connection.php'; // DB connection

header('Content-Type: application/json');

if (!isset($_SESSION['is_logged_in'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_name = trim($_POST['product_name'] ?? '');
    $category_name = trim($_POST['category_name'] ?? '');
    $status = 1;

    if (empty($product_name) || empty($category_name)) {
        echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
        exit();
    }

    // Check for duplicate
    $checkQuery = "SELECT COUNT(*) AS count FROM product_master WHERE LOWER(product_name) = LOWER(?)";
    $stmt = mysqli_prepare($conn, $checkQuery);
    mysqli_stmt_bind_param($stmt, "s", $product_name);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $count);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);

    if ($count > 0) {
        echo json_encode(['status' => 'error', 'message' => 'Duplicate: Product already exists.']);
        exit();
    }

    // Insert product
    $insertQuery = "INSERT INTO product_master (product_name, category_name, status) VALUES (?, ?, ?)";
    $stmt = mysqli_prepare($conn, $insertQuery);
    mysqli_stmt_bind_param($stmt, "ssi", $product_name, $category_name, $status);

    if (mysqli_stmt_execute($stmt)) {
        $newProduct = [
            'product_name' => htmlspecialchars($product_name),
            'category_name' => htmlspecialchars($category_name)
        ];
        echo json_encode(['status' => 'success', 'message' => 'Product inserted successfully.', 'product' => $newProduct]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Insert failed: ' . mysqli_stmt_error($stmt)]);
    }

    mysqli_stmt_close($stmt);
    mysqli_close($conn);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request.']);
}
