<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

if (!isset($_SESSION['is_logged_in'])) {
    header("Location: login.php");
    exit();
}

$login_name = $_SESSION["LOGIN_NAME"];
$login_pass = $_SESSION["EMPLOYEE_PASSWORD"];

$querylogin = "SELECT * FROM mst_users WHERE user_name = '$login_name' AND password = '$login_pass'";
$resultlogin = mysqli_query($conn, $querylogin);
$user = mysqli_fetch_assoc($resultlogin);

$name        = $user['name'];
$user_id     = $user['user_id'];
$first_name  = $user['name'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
   // 1. Collect POST data
$order_no          = $_REQUEST['order_no'] ?? ''; // TODO: Make this dynamic
$order_date        = $_REQUEST['order_date'] ?? '';
$customer_name     = $_POST['customer_name'] ?? '';
$order_type        = $_POST['order_type'] ?? '';
$entry_by          = $_POST['entry_by'] ?? $user_id;
$lead_id           = $_POST['lead_id'] ?? 0;
$lead_no           = $_POST['lead_no'] ?? '';
$ref_date          = $_POST['ref_date'] ?? '';
$reference_no      = $_POST['reference_no'] ?? '';
$call_follow_up_id = $_POST['call_follow_up_id'] ?? 0;
$step              = $_POST['step'] ?? 1;
$jcno              = $order_no;

$today       = date('Y-m-d H:i:s');
$entry_date  = date('Y-m-d');
$entry_time  = date('H:i:s');

// 2. Fetch current stage
$stage_stmt = $conn->prepare("SELECT stage FROM Stage_master WHERE step = ?");
$stage_stmt->bind_param("i", $step);
$stage_stmt->execute();
$stage_result = $stage_stmt->get_result();
$stage_row = $stage_result->fetch_assoc();
$current_stage = $stage_row['stage'] ?? 'Unknown';
$stage_stmt->close();

// 3. Insert into job_order_history
$history_stmt = $conn->prepare("
    INSERT INTO job_order_history (jcno, stage, step, entry_by, entry_date, entry_time, status)
    VALUES (?, ?, ?, ?, ?, ?, ?)
");
$history_stmt->bind_param("ssissss", $jcno, $current_stage, $step, $entry_by, $entry_date, $entry_time, $current_stage);
$history_stmt->execute();
$history_stmt->close();

// 4. Get next stage and update Job_order_Status
$new_step = $step + 1;
$stage_stmt = $conn->prepare("SELECT stage FROM Stage_master WHERE step = ?");
$stage_stmt->bind_param("i", $new_step);
$stage_stmt->execute();
$stage_result = $stage_stmt->get_result();
$stage_row = $stage_result->fetch_assoc();
$new_stage = $stage_row['stage'] ?? '';
$stage_stmt->close();


// 5. Insert into order_form
$qryOrder = $conn->prepare("
    INSERT INTO order_form (
        order_no, order_date, customer_name, order_type,
        entry_by, entry_date, entry_time,
        lead_no, lead_id, call_follow_up_id, reference_no, ref_date
    ) VALUES (?, ?, ?, ?, ?, CURDATE(), CURTIME(), ?, ?, ?, ?, ?)
");

$qryOrder->bind_param(
    "ssssiissss",
    $order_no, $order_date, $customer_name, $order_type,
    $user_id, $lead_no, $lead_id, $call_follow_up_id, $reference_no, $ref_date
);

if ($qryOrder->execute()) {
    $order_id = $conn->insert_id;
	
	$update_stmt = $conn->prepare("UPDATE Job_order_Status SET status = ?, step = ?, stage = ?, order_id = ? WHERE jcno = ?");
	$update_stmt->bind_param("sisss", $new_stage, $new_step, $new_stage, $order_id, $jcno);
	$update_stmt->execute();
	$update_stmt->close();
	
    $rows = $_POST['rows'] ?? [];

    // Prepare insert for order_details (only required fields)
    $stmt = $conn->prepare("
        INSERT INTO order_details (
            order_id, order_no, order_date, customer_name, lead_id,
            section_name, width, depth, height, qty,
            remark, vendor_name, created_at, entry_by, ref_image, product
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    // Global info (from form or session)
 

    foreach ($rows as $index => $row) {
    if (!is_array($row)) continue;

    $section = trim($row['section_name'] ?? '');
    if (empty($section)) {
        error_log("Skipped row $index: section_name is empty.");
        continue;
    }

    $width   = $row['width'] ?? '';
    $depth   = $row['depth'] ?? '';
    $height  = $row['height'] ?? '';
    $qty     = (int)($row['qty'] ?? 1);
    $remark  = $row['remark'] ?? '';
    $vendor  = $row['vendor'] ?? '';
	$product = $row['product'] ?? '';
    $ref_image = '';

    // Handle file upload
    if (
        isset($_FILES['rows']['name'][$index]['Ref_Ima']) &&
        $_FILES['rows']['error'][$index]['Ref_Ima'] === 0
    ) {
        $filename = basename($_FILES['rows']['name'][$index]['Ref_Ima']);
        $tmpname  = $_FILES['rows']['tmp_name'][$index]['Ref_Ima'];
        $targetDir = "uploads/order_files/";
        $newPath = $targetDir . uniqid() . "_" . $filename;

        if (move_uploaded_file($tmpname, $newPath)) {
            $ref_image = $newPath;
        }
    }

    $stmt->bind_param(
        "isssissssisssiss",
        $order_id, $order_no, $order_date, $customer_name, $lead_id,
        $section, $width, $depth, $height, $qty,
        $remark, $vendor, $today, $user_id, $ref_image, $product
    );

    if (!$stmt->execute()) {
        error_log("Insert failed for row {$index}: " . $stmt->error);
    }
}

    $stmt->close();
    $qryOrder->close();

    echo json_encode(["success" => true, "message" => "Order successfully saved."]);
} else {
    echo json_encode(["success" => false, "message" => "Order form insert failed: " . $conn->error]);
}
}

//exit();
echo "<script>window.location.href='index_operation.php';</script>";

?>
