<?php 
session_start();
include 'connection.php';

header('Content-Type: application/json');

if (!isset($_SESSION['is_logged_in'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vendor_name = $_POST['vendor_name'] ?? '';
    $address = $_POST['address'] ?? '';
    $contact_person = $_POST['contact_person'] ?? '';
    $contact_no = $_POST['contact_no'] ?? '';
    $gst_no = $_POST['gst_no'] ?? '';

    if (empty($vendor_name)) {
        echo json_encode(['status' => 'error', 'message' => 'Vendor Name is required.']);
        exit;
    }

    $query = "INSERT INTO vendor_master (vendor_name, address, contact_person, contact_no, gst_no) VALUES (?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $query);

    if (!$stmt) {
        echo json_encode(['status' => 'error', 'message' => mysqli_error($conn)]);
        exit;
    }

    mysqli_stmt_bind_param($stmt, "sssss", $vendor_name, $address, $contact_person, $contact_no, $gst_no);

    if (mysqli_stmt_execute($stmt)) {
        $newVendor = [
            'vendor_name' => htmlspecialchars($vendor_name),
            'address' => htmlspecialchars($address),
            'contact_person' => htmlspecialchars($contact_person),
            'contact_no' => htmlspecialchars($contact_no),
            'gst_no' => htmlspecialchars($gst_no)
        ];
        echo json_encode(['status' => 'success', 'message' => 'Vendor added successfully.', 'vendor' => $newVendor]);
    } else {
        echo json_encode(['status' => 'error', 'message' => mysqli_stmt_error($stmt)]);
    }

    mysqli_stmt_close($stmt);
    mysqli_close($conn);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request.']);
}
?>
