<?php
include 'connection.php';

// Get current date and time
$entry_date = date('Y-m-d');
$entry_time = date('H:i:s');
$entry_by = 'system'; // Or get from session/user login

// Step 1: Find new, non-empty order_no entries
$sql = "
    SELECT cl.order_no, cl.order_date, cl.customer_name, cl.lead_id, cl.lead_no, cl.call_follow_up_id
    FROM customer_leads cl
    WHERE cl.order_no IS NOT NULL 
      AND cl.order_no != ''
      AND cl.order_no NOT IN (
        SELECT JCNO FROM Job_order_Status
    )
";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Prepare insert into Job_order_Status with new 'status' and 'stage' fields
    $stmt1 = $conn->prepare("
        INSERT INTO Job_order_Status (JCNO, job_date, customer_name, step, lead_id, lead_no, call_follow_up_id, status, stage)
        VALUES (?, ?, ?, 1, ?, ?, ?, ?, ?)
    ");
    $stmt1->bind_param("ssssssss", $JCNO, $job_date, $customer_name, $lead_id, $lead_no, $call_follow_up_id, $job_status, $job_stage);

    // Prepare insert into job_order_history
    $stmt2 = $conn->prepare("
        INSERT INTO job_order_history (jcno, stage, step, entry_by, entry_date, entry_time, status)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");
    $stmt2->bind_param("ssissss", $JCNO, $stage, $step, $entry_by, $entry_date, $entry_time, $status);

    while ($row = $result->fetch_assoc()) {
        $JCNO = $row['order_no'];
        $job_date = $row['order_date'];
        $customer_name = $row['customer_name'];
        $lead_id = $row['lead_id'];
        $lead_no = $row['lead_no'];
        $call_follow_up_id = $row['call_follow_up_id'];

        // New fields with value 'Validation'
        $job_status = 'Validation';
        $job_stage = 'Validation';

        // Insert into Job_order_Status
        $stmt1->execute();

        // Insert into job_order_history
        $stage = 'New';
        $step = 5;
        $status = 'Active';

        $stmt2->execute();
    }

    //echo "Job orders and history inserted successfully.";
} else {
   // echo "No new job orders found.";
}

$conn->close();

?>
