<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

$today = date("Y-m-d");
$time = date("h:i A");

if (!isset($_SESSION['is_logged_in'])) {
    echo "Session expired. Please log in again.";
    exit;
}

$login_name = $_SESSION["LOGIN_NAME"];
$login_pass = $_SESSION["EMPLOYEE_PASSWORD"];

$querylogin = "SELECT * FROM mst_users WHERE user_name = ? AND password = ?";
$stmt = $conn->prepare($querylogin);
$stmt->bind_param("ss", $login_name, $login_pass);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    echo "Invalid user session.";
    exit;
}

$entry_by  = $user['user_id'];



$jcno          = $_REQUEST['jcno'] ?? '';
$step          = intval($_REQUEST['step'] ?? 0);
$final_status  = isset($_POST['final_status']) ? 1 : 0;
$stage         = $_POST['stage'] ?? '';
$lead_id       = $_REQUEST['lead_id'] ?? '';
$dispatch_date = $_POST['dispatch_date'] ?? null;
$dispatch_time = $_POST['dispatch_time'] ?? null;

if (empty($jcno)) {
    echo "Invalid JCNO.";
    exit;
}

// --- Always log current stage ---
$current_step = $step;

// Get current stage
$stage_sql = "SELECT stage FROM Stage_master WHERE step = ?";
$stage_stmt = $conn->prepare($stage_sql);
$stage_stmt->bind_param("i", $current_step);
$stage_stmt->execute();
$stage_result = $stage_stmt->get_result();
$stage_row = $stage_result->fetch_assoc();
$current_stage = $stage_row['stage'] ?? 'Unknown';
$stage_stmt->close();

// Insert into history
$entry_date = date('Y-m-d');
$entry_time = date('H:i:s');

$history_stmt = $conn->prepare("
    INSERT INTO job_order_history 
    (jcno, stage, step, entry_by, entry_date, entry_time, status, dispatch_time, dispatch_date) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
");
$status_text = $current_stage;
$history_stmt->bind_param(
    "ssissssss",
    $jcno,
    $current_stage,
    $current_step,
    $entry_by,
    $entry_date,
    $entry_time,
    $status_text,
	$dispatch_time,
	$dispatch_date
);
$history_stmt->execute();
$history_stmt->close();

// --- If dispatch_date + time are not empty, update ---
if (!empty($dispatch_date) && !empty($dispatch_time)) {
    $update_stmt = $conn->prepare("
        UPDATE Job_order_Status 
        SET dispatch_date = ?, dispatch_time = ? 
        WHERE jcno = ?
    ");
    $update_stmt->bind_param("sss", $dispatch_date, $dispatch_time, $jcno);
    $update_stmt->execute();
    $update_stmt->close();

    echo "Dispatch Date updated successfully.";

    // --- Send WhatsApp if step = 7 ---
    if ($step == 7) {
        $dispatch_date_fmt = date("d-M-Y", strtotime($dispatch_date));
        $dispatch_time_fmt = date("h:i A", strtotime($dispatch_time));

        $message1a = "Hello Sir,\n\nAs per our schedule, we have planned the dispatch of Order No. {$jcno} on {$dispatch_date_fmt} at {$dispatch_time_fmt}. In case of any queries, we kindly request you to revert back. Henceforth, our operations team will communicate with you directly and provide further updates.\n\nWith regards,\nOperation Head\nKitchen Studio";

        $mobile_nosa1 = '919224328435'; // TODO: make dynamic
        $payload = json_encode([
            "chatId"  => $mobile_nosa1 . "@c.us",
            "message" => $message1a
        ]);

        $curlmessage = curl_init();
        curl_setopt_array($curlmessage, [
            CURLOPT_URL            => "https://waapi.app/api/v1/instances/78483/client/action/send-message",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST  => "POST",
            CURLOPT_POSTFIELDS     => $payload,
            CURLOPT_HTTPHEADER     => [
                "Authorization: Bearer BCWFUMRgG3PWt8qWhdGjWbBMA4vGrh2uPeF8QElP76918e0d",
                "Content-Type: application/json"
            ],
        ]);

        $response = curl_exec($curlmessage);
        $err      = curl_error($curlmessage);
        curl_close($curlmessage);

        if ($err) {
            error_log("WhatsApp cURL Error: " . $err);
        }
    }
} else {
    echo "Saved history only (no dispatch date/time set).";
}

$conn->close();
?>