<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

$today = date("Y-m-d");
$time = date("h:i A");

if (!isset($_SESSION['is_logged_in'])) {
    echo "Session expired. Please log in again.";
    exit;
}

$login_name = $_SESSION["LOGIN_NAME"];
$login_pass = $_SESSION["EMPLOYEE_PASSWORD"];

$querylogin = "SELECT * FROM mst_users WHERE user_name = ? AND password = ?";
$stmt = $conn->prepare($querylogin);
$stmt->bind_param("ss", $login_name, $login_pass);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    echo "Invalid user session.";
    exit;
}

$entry_by  = $user['user_id'];

$jcno = $_POST['jcno'] ?? '';
$step = intval($_POST['step'] ?? 0);
$ppt_status     = isset($_POST['ppt_status']) ? 1 : 0;
$signoff_status = isset($_POST['signoff_status']) ? 1 : 0;
$final_status   = isset($_POST['final_status']) ? 1 : 0;

$ppt_accept     = $_POST['ppt_accept'] ?? '';
$signoff_accept = $_POST['signoff_accept'] ?? '';
$final_accept   = $_POST['final_accept'] ?? '';

if (empty($jcno)) {
    echo "Invalid JCNO.";
    exit;
}

// Update status + accepts
$sql = "UPDATE Job_order_Status 
        SET ppt_status = ?, 
            signoff_status = ?, 
            final_status = ?,
            final_accept = ?,
            signoff_accept = ?,
            ppt_accept = ?
        WHERE jcno = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param(
    "iiissss", 
    $ppt_status, 
    $signoff_status, 
    $final_status, 
    $final_accept, 
    $signoff_accept, 
    $ppt_accept, 
    $jcno
);
$stmt->execute();
$stmt->close();


// If all switches ON, update step/stage/status and log to history
if ($signoff_status && $final_status) {
   // Current (completed) step/stage BEFORE moving to next
$current_step = $step;

// Get current stage from Stage_master
$stage_sql = "SELECT stage FROM Stage_master WHERE step = ?";
$stage_stmt = $conn->prepare($stage_sql);
$stage_stmt->bind_param("i", $current_step);
$stage_stmt->execute();
$stage_result = $stage_stmt->get_result();
$stage_row = $stage_result->fetch_assoc();
$current_stage = $stage_row['stage'] ?? 'Unknown';
$stage_stmt->close();

// Log the current (completed) step
$entry_date = date('Y-m-d');
$entry_time = date('H:i:s');

$history_stmt = $conn->prepare("INSERT INTO job_order_history (jcno, stage, step, entry_by, entry_date, entry_time, status) VALUES (?, ?, ?, ?, ?, ?, ?)");
$history_stmt->bind_param("ssissss", $jcno, $current_stage, $current_step, $entry_by, $entry_date, $entry_time, $current_stage);
$history_stmt->execute();
$history_stmt->close();

// Then advance to next step
$new_step = $current_step + 1;



    $stage_stmt = $conn->prepare("SELECT stage FROM Stage_master WHERE step = ?");
    $stage_stmt->bind_param("i", $new_step);
    $stage_stmt->execute();
    $stage_result = $stage_stmt->get_result();
    $stage_row = $stage_result->fetch_assoc();
    $new_stage = $stage_row['stage'] ?? 'Ordering';
    $stage_stmt->close();

    // Update Job_order_Status
    $update_stmt = $conn->prepare("UPDATE Job_order_Status SET status = 'Ordering', step = ?, stage = ? WHERE jcno = ?");
    $update_stmt->bind_param("iss", $new_step, $new_stage, $jcno);
    $update_stmt->execute();
    $update_stmt->close();

   

    echo "Saved successfully. Status moved to next step.";
} else {
    echo "Saved, but awaiting all validations to proceed.";
}

$conn->close();
?>