<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

$today = date("Y-m-d");
$time = date("h:i A");

if (!isset($_SESSION['is_logged_in'])) {
    echo "Session expired. Please log in again.";
    exit;
}

$login_name = $_SESSION["LOGIN_NAME"];
$login_pass = $_SESSION["EMPLOYEE_PASSWORD"];

$querylogin = "SELECT * FROM mst_users WHERE user_name = ? AND password = ?";
$stmt = $conn->prepare($querylogin);
$stmt->bind_param("ss", $login_name, $login_pass);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    echo "Invalid user session.";
    exit;
}

$entry_by  = $user['user_id'];

$jcno = $_REQUEST['jcno'] ?? '';
$step = intval($_REQUEST['step'] ?? 0);
$final_status = isset($_POST['final_status']) ? 1 : 0;
$stage = $_POST['stage'] ?? '';
$lead_id = $_REQUEST['lead_id'] ?? '';
$dispatch_date = $_POST['dispatch_date'] ?? null;
$dispatch_time = $_POST['dispatch_time'] ?? null;

if (empty($jcno)) {
    echo "Invalid JCNO.";
    exit;
}

// Update current status and stage
$sql = "UPDATE Job_order_Status SET status = ?, stage = ? WHERE jcno = ?";
$stmt = $conn->prepare($sql);
$status_val = $final_status ? 'Validated' : 'Pending';
$stmt->bind_param("sss", $status_val, $stage, $jcno);
$stmt->execute();
$stmt->close();

// If final_status is ON, log and advance stage
if ($final_status) {
    // Log current stage
    $current_step = $step;

    // Get current stage name
    $stage_sql = "SELECT stage FROM Stage_master WHERE step = ?";
    $stage_stmt = $conn->prepare($stage_sql);
    $stage_stmt->bind_param("i", $current_step);
    $stage_stmt->execute();
    $stage_result = $stage_stmt->get_result();
    $stage_row = $stage_result->fetch_assoc();
    $current_stage = $stage_row['stage'] ?? 'Unknown';
    $stage_stmt->close();

    // Insert into history
    $entry_date = date('Y-m-d');
    $entry_time = date('H:i:s');

    $history_stmt = $conn->prepare("
        INSERT INTO job_order_history 
        (jcno, stage, step, entry_by, entry_date, entry_time, status) 
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");
    $history_stmt->bind_param("ssissss", $jcno, $current_stage, $current_step, $entry_by, $entry_date, $entry_time, $current_stage);
    $history_stmt->execute();
    $history_stmt->close();

    // Move to next step
    $new_step = $current_step + 1;

   // Get new stage from Stage_master
$stage_stmt = $conn->prepare("SELECT stage,status FROM Stage_master WHERE step = ?");
$stage_stmt->bind_param("i", $new_step);
$stage_stmt->execute();
$stage_result = $stage_stmt->get_result();
$stage_row = $stage_result->fetch_assoc();
$new_status = $stage_row['status'];
$new_stage = $stage_row['stage'];
$stage_stmt->close();

// Define new status label
//$new_status = 'Ordering';

// Update Job_order_Status with the new step, stage, and status
// Update Job_order_Status with the new step, stage, status, date, and time
$update_stmt = $conn->prepare("
    UPDATE Job_order_Status 
    SET status = ?, step = ?, stage = ?, dispatch_date = ?, dispatch_time = ? 
    WHERE jcno = ?
");
$update_stmt->bind_param("sissss", $new_status, $new_step, $new_stage, $dispatch_date, $dispatch_time, $jcno);
$update_stmt->execute();
$update_stmt->close();

// NEW LOGIC: If new step is 5, update customer_leads.RFD_confirm
    $cust_stmt = $conn->prepare("UPDATE customer_leads SET order_stage = ? WHERE lead_id = ?");
    $cust_stmt->bind_param("si", $new_stage, $lead_id);
    $cust_stmt->execute();
    $cust_stmt->close();




echo "Saved successfully. Status moved to next step.";

$dispatch_dateold = $_REQUEST['dispatch_dateold'];

if ($_REQUEST['step'] == '5') {

    if (!empty($dispatch_dateold) && !empty($dispatch_date)) {
        $old = new DateTime($dispatch_dateold);
        $new = new DateTime($dispatch_date);

        if ($old < $new) {
            // Rescheduled delivery
            $message2a = "Dear Sir/Madam,\n\nThis is to inform you that due to unforeseen circumstances, we are unable to deliver the materials as per the original schedule. Therefore, the delivery of Order No. {$jcno} has been rescheduled to {$new_date} at {$new_time}.\n\nShould you have any queries, please feel free to contact us.\n\nSincerely,\nKitchen Studio";
        } 
    }

    if (empty($dispatch_dateold)) {
        // First dispatch assignment
        $message1a = "Hello Sir,\n\nWith regards to your Order No. {$jcno}, we are pleased to inform you that your order is ready for dispatch. We kindly request you to remit the balance payment at the earliest so that we can plan the dispatch and schedule the assembly accordingly.\n\nWith regards,\nKitchen Studio";
    }
}

$mobile_nosa1 = '919224328435'; // must include country code, no + sign

$payload = json_encode([
    "chatId" => $mobile_nosa1 . "@c.us",
    "message" => $message1a
]);

$curlmessage = curl_init();
curl_setopt_array($curlmessage, [
    CURLOPT_URL => "https://waapi.app/api/v1/instances/78483/client/action/send-message",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer BCWFUMRgG3PWt8qWhdGjWbBMA4vGrh2uPeF8QElP76918e0d",
        "Content-Type: application/json"
    ],
]);

$response = curl_exec($curlmessage);
$err = curl_error($curlmessage);
curl_close($curlmessage);

if ($err) {
   // echo "cURL Error #:" . $err;
} else {
    //echo $response;
}


} else {
    echo "Saved, but awaiting all validations to proceed.";
}


$conn->close();
?>