<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

if (!isset($_SESSION['is_logged_in'])) {
    header("Location:login.php");
    exit();
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>Order View</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        body {
            font-family: 'Roboto', Arial, sans-serif;
            background-color: #fff;
            color: #333;
        }
        .order-header {
            position: sticky;
            top: 0;
            background-color: white;
            z-index: 1000;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header-card {
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.05);
        }
        .header-card table, table.section {
            width: 100%;
            border-collapse: collapse;
        }
        .header-card td, table.section td, table.section th {
            padding: 8px;
            font-size: 14px;
            border: 1px solid #ccc;
        }
        table.section th {
            background-color: #f2f2f2;
        }
        .section-title {
            color: white;
            font-weight: normal;
            font-size: 16px;
            padding: 10px;
        }
        @media print {
            button, a { display: none !important; }
            .order-header { position: static; box-shadow: none; }
        }
    </style>
</head>
<body>
<?php
$order_id = $_REQUEST['order_id'] ?? 0;

// Fetch order header
$order_sql = "SELECT order_no, order_date, customer_name, order_type FROM order_form WHERE order_id = ?";
$stmt = $conn->prepare($order_sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order_result = $stmt->get_result();
$order = $order_result->fetch_assoc();

// Fetch order details
$sql = "SELECT * FROM order_details WHERE order_id = ? ORDER BY id ASC";
$stmt2 = $conn->prepare($sql);
$stmt2->bind_param("i", $order_id);
$stmt2->execute();
$result = $stmt2->get_result();

// Group by section_name
$sections = [];
while ($row = $result->fetch_assoc()) {
    $section = ucwords(strtolower(trim($row['section_name'])));
    if (!$section) $section = "Kitchen Components";
    $sections[$section][] = $row;
}

?>


<div class='order-header'>
    <div class='header-card'>
     <form id="confirmForm">
    <input type="hidden" name="order_id" value="<?= $order_id ?>">
    <input type="hidden" name="jcno" value="<?php echo $_REQUEST['jcno'] ?>">
    <input type="hidden" name="step" value="<?php echo $_REQUEST['step']?>"> <!-- Replace with actual current step -->

    <table class="section">
    <tr>
        <th><input type="checkbox" id="selectAll"></th>
        <th>Product</th>
        <th>Colour</th>
        <th>Width</th>
        <th>Height</th>
		<th>Sqft</th>
        <th>Qty</th>
        <th>Depth</th>
        <th>Thickness</th>
        <th>Material</th>
        <th>Finish</th>
        <th>Back Colour</th>
        <th>Grain Direction</th>
    </tr>
        <?php
        foreach ($sections as $section => $rows) {
            foreach ($rows as $row) {
                echo "<tr>";
                echo "<td><input type='checkbox' name='confirm[]' value='{$row['id']}'></td>";
                echo "<td>" . htmlspecialchars($row['product'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['colour'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['width'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['height'] ?? '') . "</td>";
				echo "<td>" . htmlspecialchars($row['sqft'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['qty'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['depth'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['thickness'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['material'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['finish'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['back_colour'] ?? '') . "</td>";
                echo "<td>" . htmlspecialchars($row['grain_direction'] ?? '') . "</td>";
                echo "</tr>";
            }
        }
        ?>
    </table>

    <br>
   <button type="button" id="submitBtn" style="padding:10px 20px; background-color:#28a745; color:white; border:none; border-radius:5px;">
    Confirm Selected
</button>
<button type="button" id="downloadBtn" 
        style="padding:10px 20px; background-color:#007bff; color:white; border:none; border-radius:5px; margin-left:15px;">
    Download Excel
</button>


<a id="backBtn" href="index_operation.php"
   style="display: none; margin-left: 15px; padding: 10px 20px; background-color: #6c757d; color: white; text-decoration: none; border-radius: 5px;">
   <i class="fa fa-arrow-left"></i> Back
</a>

	
</form>
</div></div>
<div id="responseMsg" style="margin-top: 20px; font-weight: bold;"></div>
<script>
document.getElementById("selectAll").addEventListener("change", function () {
    const isChecked = this.checked;
    const checkboxes = document.querySelectorAll("input[name='confirm[]']");
    checkboxes.forEach(cb => cb.checked = isChecked);
});
</script>

<script>
document.getElementById("downloadBtn").addEventListener("click", function () {
    const checkboxes = document.querySelectorAll("input[name='confirm[]']:checked");
    if (checkboxes.length === 0) {
        alert("Please select at least one item to download.");
        return;
    }

    let ids = [];
    checkboxes.forEach(cb => ids.push(cb.value));

    // Create a hidden form for POST
    const form = document.createElement("form");
    form.method = "POST";
    form.action = "download_csv.php"; // ?? New PHP file
    form.style.display = "none";

    const input = document.createElement("input");
    input.type = "hidden";
    input.name = "ids";
    input.value = ids.join(",");
    form.appendChild(input);

    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
});
</script>

<script>
document.getElementById("submitBtn").addEventListener("click", function () {
    const form = document.getElementById("confirmForm");
    const formData = new FormData(form);

    fetch("confirm_order.php", {
        method: "POST",
        body: formData
    })
    .then(response => response.text())
   .then(result => {
    document.getElementById("responseMsg").innerText = result;

    // Disable checkboxes
    const checkboxes = form.querySelectorAll("input[type='checkbox']");
    checkboxes.forEach(cb => cb.disabled = true);

    // Hide Confirm button
    document.getElementById("submitBtn").style.display = "none";

    // Hide Select All
    const selectAllBox = document.getElementById("selectAll");
    if (selectAllBox) selectAllBox.style.display = "none";

    // Show Back button
    const backBtn = document.getElementById("backBtn");
    if (backBtn) backBtn.style.display = "inline-block";
})
    .catch(error => {
        console.error("Error:", error);
        document.getElementById("responseMsg").innerText = "An error occurred.";
    });
});
</script>


</body>
</html>
