<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

if (!isset($_SESSION['is_logged_in'])) {
    header("Location:login.php");
    exit();
}

$order_id = $_REQUEST['order_id'] ?? 0;

// Fetch order header
$order_sql = "SELECT order_no, order_date, customer_name, order_type FROM order_form WHERE order_id = ?";
$stmt = $conn->prepare($order_sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order_result = $stmt->get_result();
$order = $order_result->fetch_assoc();

// Fetch order details
$sql = "SELECT * FROM order_details WHERE order_id = ? ORDER BY id ASC";
$stmt2 = $conn->prepare($sql);
$stmt2->bind_param("i", $order_id);
$stmt2->execute();
$result = $stmt2->get_result();

// Group by section_name
$sections = [];
while ($row = $result->fetch_assoc()) {
    $section = ucwords(strtolower(trim($row['section_name'])));
    if (!$section) $section = "Kitchen Components";
    $sections[$section][] = $row;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Order View</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        body {
            font-family: 'Roboto', Arial, sans-serif;
            background-color: #fff;
            color: #333;
        }
        .order-header {
            position: sticky;
            top: 0;
            background-color: white;
            z-index: 1000;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header-card {
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.05);
        }
        .header-card table, table.section {
            width: 100%;
            border-collapse: collapse;
        }
        .header-card td, table.section td, table.section th {
            padding: 8px;
            font-size: 14px;
            border: 1px solid #ccc;
        }
        table.section th {
            background-color: #f2f2f2;
        }
        .section-title {
            color: white;
            font-weight: normal;
            font-size: 16px;
            padding: 10px;
        }
        @media print {
            button, a { display: none !important; }
            .order-header { position: static; box-shadow: none; }
        }
    </style>
</head>
<body>

<div style="text-align: right; margin-bottom: 20px;">
    <a href="export_order_excel.php?order_id=<?= $order_id ?>" style="background-color: #17a2b8; color: white; padding: 8px 16px; text-decoration: none; border-radius: 4px;"><i class="fa fa-file-excel"></i> Download Excel</a>
    <button onclick="window.print()" style="background-color: #007bff; color: white; padding: 8px 16px; border: none; border-radius: 4px;"><i class="fa fa-print"></i> Print</button>
    <a href="view_all_orders.php" style="background-color: #28a745; color: white; padding: 8px 16px; text-decoration: none; border-radius: 4px;"><i class="fa fa-arrow-left"></i> Back</a>
</div>

<div class='order-header'>
    <div class='header-card'>
        <table>
            <tr>
                <td><strong>Customer Name:</strong> <?= $order['customer_name'] ?></td>
                <td><strong>Order No:</strong> <?= $order['order_no'] ?></td>
            </tr>
            <tr>
                <td><strong>Order Date:</strong> <?= date('d-m-Y', strtotime($order['order_date'])) ?></td>
                <td><strong>Order Type:</strong> <?= $order['order_type'] ?></td>
            </tr>
        </table>
    </div>
</div>

<?php
function renderSection($title, $rows) {
    $sectionColors = [
        'shutter' => '#007bff',
        'carcass' => '#28a745',
        'accessories / hardware' => '#dc3545',
        'basket' => '#ffc107',
        'profile' => '#6c757d',
        'appliance' => '#e83e8c',
        'general' => '#343a40'
    ];

    $sectionConfigFull = [
        "Shutter" => ["product", "width", "height", "qty", "thickness", "material", "finish", "back_colour", "remark", "grain_direction", "vendor_name"],
        "Carcass" => ["product", "width", "depth", "height", "colour", "thickness", "remark", "vendor_name"],
        "Accessories / Hardware" => ["product", "qty", "unit", "vendor_name"],
        "Basket" => ["product", "width", "depth", "height", "qty", "remark", "vendor_name"],
        "Profile" => ["product", "width", "height", "thickness", "qty", "remark", "vendor_name"],
        "Appliance" => ["product", "brand", "code", "qty"]
    ];

    $normalizedTitle = strtolower($title);
    $color = $sectionColors[$normalizedTitle] ?? '#e0e0e0';

    echo "<table class='section'>";
    echo "<tr><td colspan='20' class='section-title' style='background-color: $color;'>$title</td></tr>";

    $key = ucwords(strtolower(trim($title)));
    if (isset($sectionConfigFull[$key])) {
        echo "<tr><th>Sr.NO.</th>";
        foreach ($sectionConfigFull[$key] as $col) {
            echo "<th>" . strtoupper(str_replace('_', ' ', $col)) . "</th>";
        }
        echo "</tr>";

        $sr = 1;
        foreach ($rows as $row) {
            echo "<tr><td>{$sr}</td>";
            foreach ($sectionConfigFull[$key] as $col) {
                echo "<td>" . htmlspecialchars($row[$col] ?? '') . "</td>";
            }
            echo "</tr>";
            $sr++;
        }
    } else {
        // Fallback for unknown sections
        echo "<tr><th>PRODUCT</th><th>QTY</th><th colspan='7'></th></tr>";
        foreach ($rows as $row) {
            echo "<tr><td>{$row['product']}</td><td>{$row['qty']}</td><td colspan='7'></td></tr>";
        }
    }

    echo "</table><br>";
}

// Render all grouped sections
foreach ($sections as $section => $rows) {
    renderSection($section, $rows);
}
?>

</body>
</html>
